package edu.uky.ai.ml;

import java.awt.BorderLayout;
import java.awt.Container;
import java.awt.Dimension;

import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.SwingConstants;

import edu.uky.ai.ml.nn.Database;
import edu.uky.ai.ml.nn.NeuralNetwork;

/**
 * An interactive GUI that allows you to interact with a neural network that
 * has been trained to recognize images of capital letters.
 * 
 * @author Stephen G. Ware
 */
public class AlphabetFrame extends JFrame {

	/** Window height */
	public static final int HEIGHT = 800;
	
	/** Window width */
	public static final int WIDTH = 500;
	
	/** Version 1.0 */
	private static final long serialVersionUID = 1L;

	/** The training database, for looking up output values */
	final Database database;
	
	/** The neural network */
	final NeuralNetwork network;
	
	/** A panel of toggelable pixels for collecting user input */
	final AlphabetInputPanel input;
	
	/** Text to display the network's output */
	final JLabel output = new JLabel("Looks like \"?\"", SwingConstants.CENTER);
	
	/**
	 * Constructs a displays a GUI for interacting with a neural network
	 * trained to recognize capital letters.
	 * 
	 * @param database the database on which the network was trained
	 * @param network the network
	 */
	public AlphabetFrame(Database database, NeuralNetwork network) {
		this.database = database;
		this.network = network;
		input = new AlphabetInputPanel(this);
		output.setFont(output.getFont().deriveFont(50f));
		setDefaultCloseOperation(EXIT_ON_CLOSE);
		Container content = getContentPane();
		content.setLayout(new BorderLayout());
		content.add(input, BorderLayout.CENTER);
		content.add(output, BorderLayout.SOUTH);
		content.setPreferredSize(new Dimension(WIDTH, HEIGHT));
		setResizable(false);
		pack();
		setLocationRelativeTo(null);
		setVisible(true);
	}
}
